************************************
*UNIVERSITA' DEGLI STUDI DI UDINE
*					
*Student:BERTONI LUCA, RICCARDO FONTANINI
*Supervisor:Prof. ESSENI DAVID
*Assistant Supervisor: Dott. Ing. ROLLO TOMMASO
*					
*MODELLO NMOS	
*08/11/2019  						
**********#PARAMETERS#******************
*temperature........T=[K];
*dimensions.........W,L=[m];
*thermal voltage....Vth=[V];
*non-ideal factor...n=[a.u.];
*thermal velocity...Term_V=[m/s];
*oxide cap..........Cinv=[F/m2];
****************************************

.subckt SUB_NMOS drainin gatein sourcein

*.param T                                    = 300 
*.param W                                    = 1e-6
*.param L                                    = 30e-9
*.param n                                    = 1
*.param tch                                  = 0.70 
*.param Term_V                               = 1.23e5 
*.param Cinv                                 = 0.020 
*.param Kds                                  = 0.04
*.param rpara                                = 60
*.param Vt0n                                 = 0.35
*.param Vt0p                                 = -0.35


.param Vt0                                  = {{(Vt0n)}}
.param Vth                                  = {BOLTZ * {(T)} / ECHARGE}
.param Vt                                   = {{(Vt0)} - {Kds} * V(drain,source)}
.param I0                                   = {{(Cinv)} * {(n)} * Vth * Term_V * ( {(tch)} / ( 2 - {(tch)} )) }

bswitch drain source I = {{(W)} * I0 * LN( 1 + exp( ( V(gate, source) - Vt)/( {(n)} * Vth ))) * (1 - exp( -(V(drain,source)) / Vth )) }

*Parasitic drain, source, and gate resistances*
rd drainin drain                            {(rpara)}
rs sourcein source                          {(rpara)}
rg gatein gate                              {(.6)}

* Cg capacitance*
C_GD gate drain                             {1e-16 * {(W)} * 1e6}
C_GS gate source                            {1e-16 * {(W)} * 1e6}

BC_GS gatein sourcein   Q = {0.5 * {(Cinv)} * {(W)} * {(L)} * {(n)} * Vth * LN(1+exp( (V(gate,source)-Vt) / ( {(n)} * Vth ))) }
BC_GD gatein drainin    Q = {0.5 * {(Cinv)} * {(W)} * {(L)} * {(n)} * Vth * LN(1+exp( (V(gate,drain)-Vt) / ( {(n)} * Vth ))) }

.ends 